{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 15:04:29 $                                        =}
{========================================================================}
unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, StdCtrls, MMObj, MMVFW, MMAVI, MMAVICtl;

type
  TAVIPlayer = class(TForm)
    AVIControl: TMMAVIControl;
    AVIVideoDisplay: TMMAVIVideoDisplay;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    MinMaxOK: Boolean;
    MinWidth,MinHeight,MaxHeight: integer;
    procedure WMGetMinMaxInfo(Var Msg: TWMGetMinMaxInfo); message WM_GETMINMAXINFO;
    procedure SetminMax;
    procedure SetInitSize;
  public
  end;

procedure PlayStream(S: TMMAVIStream);
procedure PlayFile(F: TMMCustomAVIFile);

var
  AVIPlayer: TAVIPlayer;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure PlayStream(S: TMMAVIStream);
begin
   with AVIPlayer.AVIControl do
   begin
      { first release all previous streams }
      FreeStreams;

      { now add our stream to the player }
      AddStream(S);

      if S.StreamType = stAudio then
         AVIPlayer.Caption := 'AVI Player - Audio Stream'
      else
         AVIPlayer.Caption := 'AVI Player - Video Stream';

      AVIPlayer.ShowModal;
   end;
end;

{------------------------------------------------------------------------------}
procedure PlayFile(F: TMMCustomAVIFile);
begin
   with AVIPlayer.AVIControl do
   begin
      { first release all previous streams }
      FreeStreams;

      { now add our file (all streams) to the player }
      AddFile(F);

      if F is TMMAVIFile then
         AVIPlayer.Caption := 'AVI Player - '+TMMAVIFile(F).FileName
      else
         AVIPlayer.Caption := 'AVI Player - Memory Stream';

      AVIPlayer.ShowModal;
   end;
end;

{-- TAVIPlayer ----------------------------------------------------------------}
procedure TAVIPlayer.WMGetMinMaxInfo(Var Msg: TWMGetMinMaxInfo);
begin
   if MinMaxOK then
   begin
      with Msg.MinMaxInfo^ do
      begin
         ptMinTrackSize.X := MinWidth;   { Minimum width  }
         ptMinTrackSize.Y := MinHeight;  { Minimum height }
         ptMaxTrackSize.Y := MaxHeight;  { Maximum height }
      end;
      Msg.Result := 0;       { Tell windows you have changed minmaxinfo }
   end;

   inherited;
end;

{-- TAVIPlayer ----------------------------------------------------------------}
procedure TAVIPlayer.SetMinMax;
begin
   MinWidth := (Width-ClientWidth)+AVIControl.MinWidth;
   MinHeight:= (Height-ClientHeight)+AVIControl.MinHeight;

   MaxHeight := Screen.Height;

   if not AVIControl.hasVideo then
   begin
      Height := MinHeight;
      MaxHeight := MinHeight;
   end;
end;

{-- TAVIPlayer ----------------------------------------------------------------}
procedure TAVIPlayer.SetInitSize;
var
   R: TRect;

begin
   if AVIControl.hasVideo then
   begin
      { get the size of the video }
      R := AVIVideoDisplay.GetVideoSize(0);
      { now add the Bevel size }
      InflateRect(R,AVIVideoDisplay.BevelExtend,AVIVideoDisplay.BevelExtend);

      ClientWidth  := R.Right-R.Left;
      ClientHeight := (R.Bottom-R.Top)+AVIControl.Height;
   end
   else
   begin
      ClientWidth := AVIControl.MinWidth;
      ClientHeight:= AVIControl.MinHeight;
   end;
end;

{-- TAVIPlayer ----------------------------------------------------------------}
procedure TAVIPlayer.FormCreate(Sender: TObject);
begin
   MinMaxOK := True;
   SetMinMax;
end;

{-- TAVIPlayer ----------------------------------------------------------------}
procedure TAVIPlayer.FormShow(Sender: TObject);
begin
   SetMinMax;
   SetInitSize;
   AVIControl.Play;
end;

{-- TAVIPlayer ----------------------------------------------------------------}
procedure TAVIPlayer.FormHide(Sender: TObject);
begin
   { stop playing }
   AVIControl.Stop;
   { free all allocated streams }
   AVIControl.FreeStreams;
end;

end.

